Attribute VB_Name = "Declaraciones"
'Declara las funciones de comunicacin con el dispositivo CAPI
Declare Function CAPI_REGISTER Lib "Capi2032.Dll" (ByVal D_MessageBuffersize As Long, ByVal D_maxLogicalConnection As Long, ByVal D_maxBDataBlocks As Long, ByVal D_maxBDataLen As Long, ByRef D_AppID As Long) As Long
Declare Function CAPI_RELEASE Lib "Capi2032.Dll" (ByVal D_AppID As Long) As Long
Declare Function CAPI_WAIT_FOR_SIGNAL Lib "Capi2032.Dll" (ByVal D_AppID As Long) As Long
Declare Function CAPI_PUT_MESSAGE Lib "Capi2032.Dll" (ByVal D_AppID As Long, pcapimessage As Any) As Long
Declare Function CAPI_GET_MESSAGE Lib "Capi2032.Dll" (ByVal D_AppID As Long, ByRef lpCapiBuffer As Long) As Long
'Funcin para llenar las variables con los mensajes CAPI
Declare Sub RtlMoveMemory Lib "Kernel32.Dll" (lpRecieve As Any, ByVal lpCapiBuffer As Long, ByVal iMaxLength As Long) 'Generell Verwendete Variable

Public AppId As Long 'Identificacin de la Aplicacin
Public lpCapiBuffer As Long

Public CRLF As String

Public Const maxLogicalConnection As Long = 2
Public Const MessageBuffersize As Long = 1024 + (1024 * maxLogicalConnection)
Public Const maxBDataBlocks As Long = 7
Public Const maxBDataLen As Long = 2048
Public Const HeaderLength As Long = 8

'----- Comandos CAPI -----
Public Const CAPI_ALERT = &H1
Public Const CAPI_CONNECT = &H2
Public Const CAPI_CONNECT_ACTIVE = &H3
Public Const CAPI_CONNECT_B3_ACTIVE = &H83
Public Const CAPI_CONNECT_B3 = &H82
Public Const CAPI_CONNECT_B3_T90_ACTIVE = &H88
Public Const CAPI_DATA_B3 = &H86
Public Const CAPI_DISCONNECT_B3 = &H84
Public Const CAPI_DISCONNECT = &H4
Public Const CAPI_FACILITY = &H80
Public Const CAPI_INFO = &H8
Public Const CAPI_LISTEN = &H5
Public Const CAPI_MANUFACTURER = &HFF
Public Const CAPI_RESET_B3 = &H87
Public Const CAPI_SELECT_B_PROTOCOL = &H41

'----- Subcomandos CAPI-----
Public Const CAPI_REQ = &H80
Public Const CAPI_CONF = &H81
Public Const CAPI_IND = &H82
Public Const CAPI_RESP = &H83

'Estructura para las cabeceras de los mensajes
Public Type MessageHeader
    length As Integer
    AppId As Integer
    Command As Byte
    Subcommand As Byte
    Message_Number As Integer
End Type
Public MessageHeader As MessageHeader

'Estructura para el mensaje de indicacin de conexin
Public Type ConnectInd
    PLCI As Long
    CIP As Integer
    buffer As String * 100
End Type
Public ConnectInd As ConnectInd

'Estructura para la peticin de recepcin de mensajes
Public Type ListenREQ
    length As Integer
    AppId As Integer
    Command As Byte
    Subcommand As Byte
    Message_Number As Integer
    controller As Long
    InfoMask As Long
    CIPMask As Long
    CIPMas2 As Long
    CallingParty As Byte
    CallingPartySub As Byte
End Type
Public ListenREQ As ListenREQ
Public Function LeerMensajeCAPI()
    'Recoge el primer mensaje de la cola
    x = CAPI_GET_MESSAGE(ByVal AppId, lpCapiBuffer)
    'Si no hay mensaje, acaba
    If x <> 0 Then Exit Function
    'Pasa los datos de la cabecera del mensaje a las variables
    Call RtlMoveMemory(MessageHeader, ByVal lpCapiBuffer, ByVal HeaderLength)
    'Selecciona las acciones para los distintos mensajes
    Select Case MessageHeader.Command
        Case CAPI_CONNECT
            Select Case MessageHeader.Subcommand
                Case CAPI_IND 'Indicacin de conexin
                    'Busca el resto del mensaje
                    Call RtlMoveMemory(ConnectInd, ByVal (lpCapiBuffer + HeaderLength), ByVal (MessageHeader.length - HeaderLength))
                    L1 = Asc(Mid$(ConnectInd.buffer, 1, 1)) 'longitud del nmero llamado
                    If L1 > 0 Then
                       NumLlamado$ = Mid$(ConnectInd.buffer, 3, L1 - 1)
                    End If
                    'Busca el nmero llamado
                    L2 = Asc(Mid$(ConnectInd.buffer, L1 + 2, 1))
                    If L2 > 0 Then
                        If L2 > 2 Then 'nmero normal
                            NumLlamante = Mid$(ConnectInd.buffer, L1 + 5, L2 - 2)
                        Else 'cdigos de RDSI
                            N = Asc(Mid$(ConnectInd.buffer, L1 + 4, 1))
                            c = Asc(Mid$(ConnectInd.buffer, L1 + 3, 1))
                            If ((N And 32) = 32) And ((N And 64) = 0) Then
                                If ((c And 1) = 1) And ((c And 2) = 0) And ((c And 4) = 0) And ((c And 8) = 0) Then
                                    NumLlamante = "RDSI oculto"
                                ElseIf c = 0 Then
                                    NumLlamante = "Desconocido"
                                Else
                                    NumLlamante = "Cdigo oculto: " + Str$(c)
                                End If
                            End If
                        End If
                    Else
                        NumLlamante = "Error"
                    End If
                    LeerMensajeCAPI = "LLamado  " & NumLlamado & CRLF & "LLamante " & NumLlamante & CRLF & CRLF & "     Recibido a las " & Time
                'End Case Subcomando
            End Select
        'End Case Comando
        Case Else
            LeerMensajeCAPI = "ltimo comando: " & Hex(Val(MessageHeader.Command)) & CRLF & "     Subcomando: " & Hex(Val(MessageHeader.Subcommand)) & CRLF & CRLF & "     Recibido a las " & Time
    End Select
End Function
